<?php include 'header.php'; ?>

    <section class="hero" style="min-height: 40vh; height: 40vh; background-image: linear-gradient(rgba(11, 36, 71, 0.8), rgba(11, 36, 71, 0.7)), url('https://images.unsplash.com/photo-1524178232363-1fb2b075b655?q=80&w=1600&auto=format&fit=crop');">
        <h1>About Zenith Group Of Schools</h1>
        <p class="sub-hero">Rising Towards Excellence</p>
    </section>

    <section class="about-section">
        <div class="about-text">
            <span class="highlight-text">Who We Are</span>
            <h2>Zenith Group of Schools</h2>
            <p>
                <strong>Zenith Group of Schools</strong> is a future-focused educational network in Jahazpur & Deoli, committed to nurturing young minds through <strong>Artificial Intelligence, Model Making, Robotics, and Model-Based Learning</strong>.
            </p>
            <p>
                We believe that education should go beyond textbooks and classrooms. Led by IIT alumni, we empower students to think critically, explore creatively, and innovate confidently. At Zenith, learning is not limited to memorization; we prepare students for the real world.
            </p>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1503676260728-1c00da094a0b?q=80&w=800&auto=format&fit=crop" alt="Students Learning" style="box-shadow: 15px 15px 0 var(--navy); border-radius: 10px;">
        </div>
    </section>

    <section class="about-section" style="background-color: #f0f8ff; flex-direction: row-reverse;">
        <div class="about-text">
            <span class="highlight-text">Our Identity</span>
            <h2>What's in a Name?</h2>
            
            <div style="background: #fff; padding: 25px; border-left: 5px solid var(--orange); border-radius: 5px; margin-top: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.05);">
                <h3 style="color: var(--navy); margin-top: 0; font-size: 20px;">ZENITH (शिखर)</h3>
                
                <p style="margin-bottom: 15px; color: #555;">
                    The word <strong>'Zenith'</strong> refers to the highest point reached by a celestial body. It symbolizes the <strong>peak of potential</strong>.
                </p>
                <p style="margin-bottom: 0; color: #555;">
    Our mission is captured in our tagline: 
    <br>
    <span style="font-size: 18px; color: var(--navy); font-weight: 700; background: var(--gold); padding: 2px 10px; border-radius: 4px; color: white;">
        "Rising Towards Excellence"
    </span>
    <br><br>
    We combine modern <strong>Innovation</strong> with strong values to help every student reach their personal zenith.
</p>
            </div>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?q=80&w=800&auto=format&fit=crop" alt="Rising to the Top" style="border-radius: 10px; box-shadow: -15px 15px 0 var(--gold);">
        </div>
    </section>

    <section class="about-section" style="background-color: #fafafa;">
        <div class="about-text">
            <span class="highlight-text">Our Culture</span>
            <h2>Our Core Values</h2>
            <p>At Zenith, we build character along with competence. Our values define who we are and how we teach.</p>
            
            <ul class="feature-list" style="margin-top: 20px;">
                <li><strong>Integrity:</strong> Being honest and ethical in all actions.</li>
                <li><strong>Innovation:</strong> Always looking for creative solutions.</li>
                <li><strong>Empathy:</strong> Understanding and respecting others.</li>
                <li><strong>Resilience:</strong> Never giving up in the face of challenges.</li>
                <li><strong>Collaboration:</strong> Working together to achieve greatness.</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1516321318423-f06f85e504b3?q=80&w=800&auto=format&fit=crop" alt="Core Values" style="box-shadow: 15px 15px 0 var(--navy); border-radius: 10px;">
        </div>
    </section>

    <section class="mission-vision-section">
        <div class="mv-box">
            <h3>Our Vision</h3>
            <p>To nurture curious, confident, and capable learners who are prepared to become innovators, leaders, and responsible global citizens.</p>
        </div>
        
        <div class="mv-box" style="border-left-color: var(--navy);">
            <h3>Our Mission</h3>
            <ul>
                <li>To provide AI-driven and technology-enabled education</li>
                <li>To promote hands-on, model-based learning</li>
                <li>To encourage creativity, critical thinking, and innovation</li>
                <li>To prepare students for future academic and professional challenges</li>
            </ul>
        </div>
    </section>

    <section class="about-section" style="background: #fff;">
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1560250097-0b93528c311a?q=80&w=800&auto=format&fit=crop" 
                 alt="Director Mr. Nitesh Meena" 
                 style="box-shadow: 15px 15px 0px var(--navy); border-radius: 10px; border: 1px solid #ddd;">
        </div>
        <div class="about-text">
            <span class="highlight-text">Visionary Leadership</span>
            <h2 style="color: var(--navy);">Director's Message</h2>
            <p>
                "Welcome to Zenith Group of Schools. As an engineer, I believe in the power of logic, innovation, and hands-on problem solving. Our vision is to create an educational environment where technology meets tradition."
            </p>
            <p>
                By integrating <strong>AI, Robotics, and Model-Based Learning</strong> into our core curriculum, we ensure that our students are not just consumers of technology, but creators of it. We are committed to building a launchpad for future innovators right here in Jahazpur & Deoli.
            </p>
            
            <div style="margin-top: 25px; border-left: 4px solid var(--gold); padding-left: 15px;">
                <h3 style="margin: 0; font-size: 22px; color: var(--navy);">Mr. Nitesh Meena</h3>
                
                <p style="margin: 5px 0; font-size: 15px; color: #444; font-weight: 600;">
                    🎓 B.Tech (Chemical Engineering), IIT Bombay
                </p>

                <span style="color: var(--orange); font-weight: 700; letter-spacing: 1px; font-size: 14px; text-transform: uppercase;">Founder & Director</span>
            </div>
        </div>
    </section>

    <section class="about-section" style="background: #fafafa; flex-direction: row-reverse;">
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?q=80&w=800&auto=format&fit=crop" 
                 alt="Principal Mr. Neeraj Kumar" 
                 style="box-shadow: -15px 15px 0px var(--gold); border-radius: 10px; border: 1px solid #ddd;">
        </div>
        <div class="about-text">
            <span class="highlight-text">Academic Excellence</span>
            <h2 style="color: var(--navy);">Principal's Message</h2>
            <p>
                "Education is a shared commitment between dedicated teachers, motivated students, and enthusiastic parents. With a strong foundation in science and mathematics, I believe in fostering analytical thinking and curiosity in every child."
            </p>
            <p>
                At Zenith, our focus is on holistic development—balancing rigorous academics with sports, arts, and values. We ensure that our students not only understand concepts but apply them in real life to become confident, responsible global citizens.
            </p>

            <div style="margin-top: 25px; border-left: 4px solid var(--navy); padding-left: 15px;">
                <h3 style="margin: 0; font-size: 22px; color: var(--navy);">Mr. Neeraj Kumar</h3>
                
                <p style="margin: 5px 0; font-size: 15px; color: #444; font-weight: 600;">
                    🎓 B.Sc. (PCM), JNU
                </p>

                <span style="color: var(--orange); font-weight: 700; letter-spacing: 1px; font-size: 14px; text-transform: uppercase;">Principal</span>
            </div>
        </div>
    </section>

    <?php include 'footer.php'; ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger-btn');
            const navMenu = document.getElementById('nav-menu');
            const navLinks = document.querySelectorAll('#nav-menu a');

            hamburger.addEventListener('click', function() {
                hamburger.classList.toggle('active');
                navMenu.classList.toggle('active');
            });

            navLinks.forEach(function(link) {
                link.addEventListener('click', function() {
                    hamburger.classList.remove('active');
                    navMenu.classList.remove('active');
                });
            });
        });
    </script>
</body>
</html>