<?php include 'header.php'; ?>

    <section class="hero" style="min-height: 50vh; background-image: linear-gradient(rgba(11, 36, 71, 0.8), rgba(11, 36, 71, 0.7)), url('https://images.unsplash.com/photo-1509062522246-3755977927d7?q=80&w=1600&auto=format&fit=crop');">
        <h1>Academics</h1>
        <p class="sub-hero">Balanced & Future-Ready Curriculum</p>
    </section>

    <section class="about-section">
        <div class="about-text">
            <span class="highlight-text">Curriculum</span>
            <h2>Academic Excellence</h2>
            <p>Our curriculum is aligned with international education standards, enriched with modern teaching practices and future skills. We aim to help every child achieve their highest potential academically, socially, and creatively.</p>
            
            <h3 style="margin-top:20px; color:var(--orange);">Core Focus Areas</h3>
            <ul class="feature-list">
                <li>Strong foundation in Mathematics & Science</li>
                <li>Integration of AI, Robotics, and STEM education</li>
                <li>Model-based and experiential learning approach</li>
                <li>Life skills, communication, and leadership development</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1509062522246-3755977927d7?q=80&w=800&auto=format&fit=crop" alt="Classroom">
        </div>
    </section>

    <section class="why-section" style="background: var(--navy);">
        <h2 style="color:var(--white);">Our Faculty</h2>
        <p style="color:#ddd; max-width: 600px; margin: 0 auto 30px auto;">Our teachers are trained, skilled, and passionate about nurturing young minds. They act as mentors and facilitators.</p>
        
        <div class="why-grid">
            <div class="why-card">
                <span class="icon">👨‍🏫</span>
                <h4>Skilled Mentors</h4>
                <p>Continuous teacher training programs.</p>
            </div>
            <div class="why-card">
                <span class="icon">💻</span>
                <h4>Tech-Savvy</h4>
                <p>Technology-integrated teaching methods.</p>
            </div>
            <div class="why-card">
                <span class="icon">❤️</span>
                <h4>Student-Centric</h4>
                <p>Focus on individual student growth.</p>
            </div>
        </div>
    </section>

    <section class="about-section" style="flex-direction: row-reverse; background: #fafafa;">
        <div class="about-text">
            <span class="highlight-text">Holistic Growth</span>
            <h2>Beyond The Classroom</h2>
            <p>At Zenith Group Of Schools, we focus on the overall development of every child through:</p>
            <ul class="feature-list">
                <li>Robotics & innovation projects</li>
                <li>Science exhibitions & model making</li>
                <li>Creative arts & cultural activities</li>
                <li>Sports & physical education</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1564951434112-64d74cc2a2d7?q=80&w=800&auto=format&fit=crop" alt="Sports and Activities">
        </div>
    </section>
    <section class="about-section" style="background: var(--white); text-align: center; display: block;">
        <span class="highlight-text" style="margin: 0 auto;">No Rote Learning</span>
        <h2 style="margin-bottom: 30px;">Holistic Assessment</h2>
        <p style="max-width: 800px; margin: 0 auto 40px auto;">
            We do not judge a child solely based on marks. Our assessment pattern is continuous and comprehensive.
        </p>
        
        <div class="lab-grid">
             <div class="lab-card" style="border-bottom-color: var(--gold);">
                <h3>📊 Projects</h3>
                <p>Marks for practical implementation and models.</p>
            </div>
            <div class="lab-card" style="border-bottom-color: var(--navy);">
                <h3>🗣️ Viva & Orals</h3>
                <p>Assessing communication and concept clarity.</p>
            </div>
            <div class="lab-card" style="border-bottom-color: var(--orange);">
                <h3>📝 Periodic Tests</h3>
                <p>Regular check-ins to track academic progress.</p>
            </div>
        </div>
    </section>
   <?php include 'footer.php'; ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.getElementById('hamburger-btn');
            const navMenu = document.getElementById('nav-menu');
            const navLinks = document.querySelectorAll('#nav-menu a');
            hamburger.addEventListener('click', function() { hamburger.classList.toggle('active'); navMenu.classList.toggle('active'); });
            navLinks.forEach(function(link) { link.addEventListener('click', function() { hamburger.classList.remove('active'); navMenu.classList.remove('active'); }); });
        });
    </script>
</body>
</html>