<?php include 'header.php'; ?>

    <section class="hero" style="min-height: 60vh; background-image: linear-gradient(rgba(5, 16, 32, 0.8), rgba(5, 16, 32, 0.6)), url('https://images.unsplash.com/photo-1581092160562-40aa08e78837?q=80&w=1600&auto=format&fit=crop');">
        <h1 style="font-size: 56px;">Model Making Hub</h1>
        <p class="sub-hero">Imagine • Design • Create</p>
        <p style="color: #ccc; max-width: 600px; font-size: 18px;">Where young minds meet future technology.</p>
    </section>
    <div style="background: var(--navy); color: white; text-align: center; padding: 15px; border-bottom: 4px solid var(--gold);">
        <p style="margin: 0; font-size: 14px; letter-spacing: 0.5px;">
            🚀 <strong>
            <span style="color: var(--gold); font-weight: 700;">Advantage Zenith: Our STEM & Robotics Curriculum is designed under the guidance of an IIT Bombay Alumnus</span>. </strong> 
        </p>
    </div>
    <section class="about-section" style="text-align: center; flex-direction: column; padding-bottom: 20px;">
        <span class="highlight-text" style="margin: 0 auto;">Beyond Textbooks</span>
        <h2 style="font-size: 36px; margin-bottom: 20px;">The Laboratory of Dreams</h2>
        <p style="max-width: 800px; margin: 0 auto; font-size: 18px; color: #555;">
            Our labs are not just rooms with equipment; they are incubators for future scientists and engineers. We combine <strong>Artificial Intelligence, Robotics, and Physical Modeling</strong> to provide a complete STEM experience.
        </p>
    </section>

    <section class="about-section">
        <div class="about-text">
            <span class="highlight-text">Computational Thinking</span>
            <h2 style="color: var(--navy);">Artificial Intelligence (AI)</h2>
            <p>In the AI zone, students move beyond consuming technology to creating it. They understand how machines learn and make decisions.</p>
            <ul class="feature-list">
                <li><strong>Coding Logic:</strong> Block-based coding for juniors to Python for seniors.</li>
                <li><strong>Machine Learning:</strong> Training simple models to recognize images and voice.</li>
                <li><strong>Smart Algorithms:</strong> Solving puzzles and mazes using code.</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1555255707-c07966088b7b?q=80&w=800&auto=format&fit=crop" alt="AI and Coding" style="box-shadow: -15px 15px 0px var(--gold);">
        </div>
    </section>

    <section class="about-section" style="flex-direction: row-reverse; background-color: #fafafa;">
        <div class="about-text">
            <span class="highlight-text">Engineering & Mechanics</span>
            <h2 style="color: var(--orange);">Robotics & Automation</h2>
            <p>Our Robotics program bridges the gap between software and hardware. Students build machines that can move, sense, and interact with the world.</p>
            <ul class="feature-list">
                <li><strong>Mechanical Design:</strong> Assembling gears, motors, and chassis.</li>
                <li><strong>Sensor Integration:</strong> Using IR, Ultrasonic, and Touch sensors.</li>
                <li><strong>Autonomous Bots:</strong> Line followers, obstacle avoiders, and robotic arms.</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1485827404703-89b55fcc595e?q=80&w=800&auto=format&fit=crop" alt="Robot Technology" style="box-shadow: 15px 15px 0px var(--navy); border-radius: 10px;">
        </div>
    </section>

    <section class="about-section">
        <div class="about-text">
            <span class="highlight-text">Hands-on Science</span>
            <h2 style="color: var(--navy);">Science Models Making</h2>
            <p>Physics and Chemistry come alive here. We encourage 'Learning by Doing' through scientific models and prototypes.</p>
            <ul class="feature-list">
                <li><strong>STEM Projects:</strong> Working models of windmills, dams, and circuits.</li>
                <li><strong>Prototyping:</strong> Using cardboard, wood, and 3D printing to build ideas.</li>
                <li><strong>Design Thinking:</strong> Solving real-world problems through innovation.</li>
            </ul>
        </div>
        <div class="about-image">
            <img src="https://images.unsplash.com/photo-1532094349884-543bc11b234d?q=80&w=800&auto=format&fit=crop" alt="Science Experiment" style="box-shadow: -15px 15px 0px var(--gold); border-radius: 10px;">
        </div>
    </section>

    <section style="background: var(--navy); padding: 80px 10%; color: var(--white);">
        <div style="text-align: center; margin-bottom: 50px;">
            <h2 style="color: var(--white);">High-Tech Equipment</h2>
            <p style="color: var(--gold);">Powering the next generation of inventors</p>
        </div>

        <div style="display: flex; flex-wrap: wrap; gap: 30px; justify-content: center;">
            <div style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 10px; width: 250px; text-align: center; border: 1px solid rgba(255,255,255,0.2);">
                <span style="font-size: 40px;">🖨️</span>
                <h3 style="color: var(--white); margin: 15px 0;">3D Printers</h3>
                <p style="font-size: 14px; color: #ddd;">Converting digital designs into physical objects.</p>
            </div>
            <div style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 10px; width: 250px; text-align: center; border: 1px solid rgba(255,255,255,0.2);">
                <span style="font-size: 40px;">🚁</span>
                <h3 style="color: var(--white); margin: 15px 0;">Drones</h3>
                <p style="font-size: 14px; color: #ddd;">Understanding aerodynamics and flight stability.</p>
            </div>
            <div style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 10px; width: 250px; text-align: center; border: 1px solid rgba(255,255,255,0.2);">
                <span style="font-size: 40px;">🔭</span>
                <h3 style="color: var(--white); margin: 15px 0;">Telescopes</h3>
                <p style="font-size: 14px; color: #ddd;">Exploring space and astronomy concepts.</p>
            </div>
            <div style="background: rgba(255,255,255,0.1); padding: 20px; border-radius: 10px; width: 250px; text-align: center; border: 1px solid rgba(255,255,255,0.2);">
                <span style="font-size: 40px;">🔬</span>
                <h3 style="color: var(--white); margin: 15px 0;">Microscopes</h3>
                <p style="font-size: 14px; color: #ddd;">Deep diving into biology and micro-science.</p>
            </div>
        </div>
    </section>

    <section style="padding: 80px 5%; text-align: center;">
        <span class="highlight-text">Gallery</span>
        <h2>Students in Action</h2>
        <br>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 15px;">
            <img src="https://images.unsplash.com/photo-1531545514256-b1400bc00f31?q=80&w=600&auto=format&fit=crop" style="width:100%; height: 250px; object-fit: cover; border-radius: 8px;">
            <img src="https://images.unsplash.com/photo-1517048676732-d65bc937f952?q=80&w=600&auto=format&fit=crop" style="width:100%; height: 250px; object-fit: cover; border-radius: 8px;">
            <img src="https://images.unsplash.com/photo-1581092580497-e0d23cbdf1dc?q=80&w=600&auto=format&fit=crop" style="width:100%; height: 250px; object-fit: cover; border-radius: 8px;">
        </div>
    </section>

    <section style="padding: 60px 20px; text-align: center; background: var(--cream);">
        <h2 style="color: var(--navy);">Ignite Your Child's Curiosity</h2>
        <p style="max-width: 700px; margin: 0 auto 30px auto;">
            Give your child the advantage of future-ready skills. Admissions Open for 2026-27.
        </p>
        <a href="admission_form.php" class="btn-primary">Enquire for Admission</a>
    </section>

<?php include 'footer.php'; ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const hamburger = document.getElementById('hamburger-btn');
        const navMenu = document.getElementById('nav-menu');
        const navLinks = document.querySelectorAll('#nav-menu a');

        hamburger.addEventListener('click', function() {
            hamburger.classList.toggle('active');
            navMenu.classList.toggle('active');
        });

        navLinks.forEach(function(link) {
            link.addEventListener('click', function() {
                hamburger.classList.remove('active');
                navMenu.classList.remove('active');
            });
        });
    });
</script>
</body>
</html>